package com.androidbook.resourceroundup;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.xmlpull.v1.XmlPullParserException;
import android.app.Activity;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.NinePatchDrawable;
import android.os.Bundle;
import android.text.Html;
import android.text.TextUtils;
import android.util.Log;
import android.view.Menu;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;


public class ResourceRoundupActivity extends Activity {
    /** Wywoływana podczas pierwszego wykonywania aktywności. */
	private static final String DEBUG_TAG= "Dziennik ResourceRoundup";
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        
        
        // PROSTA OBSŁUGA ZASOBÓW (łańcuch znaków, łańcuch z pogrubieniem, kolor, określenie wymiaru oraz prosty zasób graficzny.
        String myResourceString = getResources().getString(R.string.hello);  
        CharSequence myResourceStringRich = getResources().getText(R.string.boldhello);
        int myResourceColor = getResources().getColor(R.color.prettyTextColor);
        float myResourceDimension = getResources().getDimension(R.dimen.textPointSize);
        ColorDrawable myResourceDrawable = (ColorDrawable)getResources().getDrawable(R.drawable.redDrawable);
        
        Log.d(DEBUG_TAG, "myResourceString ma wartość: " + myResourceString);
        Log.d(DEBUG_TAG, "myResourceStringRich ma wartość: " + myResourceStringRich.toString());
        Log.d(DEBUG_TAG, "myResourceColor ma wartość: " + myResourceColor);
        Log.d(DEBUG_TAG, "myResourceDimension ma wartość: " + myResourceDimension);
        Log.d(DEBUG_TAG, "myResourceDrawable ma wartość: " + myResourceDrawable.toString()); // Not very exciting, I know.

        // OBSŁUGA TABLIC Z ŁAŃCUCHAMI ZNAKÓW
        String[] aFlavors = getResources().getStringArray(R.array.flavors);
        for(int i=0; i<aFlavors.length; i++)
        {
         	Log.d(DEBUG_TAG, "aFlavors["+ i + "] ma wartość: "+ aFlavors[i]);
        } 
        
        // OBSŁUGA ŁAŃCUCHÓW ZE ZNACZNIKAMI FORMATUJĄCYMI
        // Można skorzystać z metody htmlEncode by upewnić się, że łańcuch jest zapisany w prawidłowej postaci. 
        // Oczywiście słowo "Hasło" nie potrzebuje niczego specjalnego... 
        // Ale gdyby to był tekst taki jak ten "McDonal's: i'm lovin'it!", to na pewno będziesz zadowolony, że jej użyłeś.
        String escapedWin = TextUtils.htmlEncode("Won");
        Log.d(DEBUG_TAG, "escapedWin ma wartość: " + escapedWin);
        
        // Najpierw, prosty łańcuch formatujący.
        String mySimpleWinString = getResources().getString(R.string.simpleformatString);
        Log.d(DEBUG_TAG, "mySimpleWinString ma wartość: " + mySimpleWinString);
        String resultsText1 = String.format(mySimpleWinString, 5, 5, escapedWin);
        Log.d(DEBUG_TAG, "resultsText1 (simple) value is: " + resultsText1);
        
        // A taraz, łańcuch formatujący ze stylami.
        String resultsTextFormat = getResources().getString(R.string.formatStringWithTwoNumbersAndAString);
        Log.d(DEBUG_TAG, "resultsTextFormat ma wartość: " + resultsTextFormat);
        String resultsText = String.format(resultsTextFormat, 5, 5, escapedWin);
        Log.d(DEBUG_TAG, "resultsText ma wartość: " + resultsText);
        CharSequence styledResults = Html.fromHtml(resultsText);
        Log.d(DEBUG_TAG, "styledResults ma wartość: " + styledResults);
        
        // OBSŁUGA KONTROLEK, WIDOKÓW, OBRAZKÓW
        // Pobieramy kontrolkę ImageView i wyświetlamy w niej obrazek.
        ImageView flagImageView = (ImageView)findViewById(R.id.ImageView01);
        flagImageView.setImageResource(R.drawable.flag);
        
        // Pobieramy obrazek i sprawdzamy kilka jego parametrów.
        BitmapDrawable bitmapFlag = (BitmapDrawable)getResources().getDrawable(R.drawable.flag); 
        Log.d(DEBUG_TAG, "bitmapFlag ma WYSOKOŚĆ: " + bitmapFlag.getIntrinsicHeight() + " i SZEROKOŚĆ: " + bitmapFlag.getIntrinsicWidth());
        
        // Pobieramy obrazke typu  Nine-patch i sprawdzamy kilka jego parametrów. 
        NinePatchDrawable stretchy = (NinePatchDrawable)getResources().getDrawable(R.drawable.pyramid);
        Log.d(DEBUG_TAG, "stretchy ma WYSOKOŚĆ: " + stretchy.getIntrinsicHeight() + " i SZEROKOŚĆ: " + stretchy.getIntrinsicWidth());
        
        // OBSŁUGA ANIMACJI
        // Obracanie obrazka przy użyciu animacji zdefiniownej w spin.xml.
        Animation an =  AnimationUtils.loadAnimation(this, R.anim.spin);
        flagImageView.startAnimation(an);
 
        // Uruchomienie animacji pulsującego owalu zdefiniowanej w pliku pulse.xml.
        ImageView redOval = (ImageView)findViewById(R.id.ImageView02);
        Animation an2 =  AnimationUtils.loadAnimation(this, R.anim.pulse);
        redOval.startAnimation(an2);
 
        // OBSŁUGA XML
        XmlResourceParser myPets = getResources().getXml(R.xml.my_pets);
        
        try {
			inspectPetsXml(myPets);
		} catch (Exception e) {
			Log.e(DEBUG_TAG, "Błąd InspectPetsXml.", e);
		}
		


		// OBSŁUGA NIEPRZETWARZANYCH PLIKÓW
		InputStream iFile = getResources().openRawResource(R.raw.limerick);
        try {
        	String strFile = inputStreamToString(iFile);
        	Log.d(DEBUG_TAG, "Oto fraszka odczytywana przy użyciu strumienia InputStream:\n"+ strFile); 
        	
		} catch (Exception e) {
			Log.e(DEBUG_TAG, "Błąd InputStreamToString.", e);
		}	
				
    }
    
    // Metoda wywoływana gdy użytkownik naciśnie przycisk Menu
    @Override
	public boolean onCreateOptionsMenu(Menu menu) {
		// OBSŁUGA ZASOBU MENU
    	getMenuInflater().inflate(R.menu.speed, menu);
    	return true;
	}

    // Przetworzenie konkretnego pliku XML i wyświetlenie zdefiniowanych w nim zwierzaków i ich atrybutów
	public static void inspectPetsXml(XmlResourceParser myPets) throws XmlPullParserException, IOException
    {
    	
	    // Analiza zwierzeków.
    	int eventType = -1;
        while (eventType != XmlResourceParser.END_DOCUMENT) {
         if(eventType == XmlResourceParser.START_DOCUMENT) {
        	 Log.d(DEBUG_TAG, "Document Start");
         } else if(eventType == XmlResourceParser.START_TAG) {
        	
            // Pobranie nazwy znacznika (np.: pets lub pet)
        	String strName = myPets.getName();

        	if(strName.equals("pet"))
        	{
       		 	 Log.d(DEBUG_TAG, "Znaleziono zwierzaka");        		 
        		 Log.d(DEBUG_TAG, "Imię: "+myPets.getAttributeValue(null, "name"));
        		 Log.d(DEBUG_TAG, "Gatunek: "+myPets.getAttributeValue(null, "type"));      
        	}
         } 
         
         eventType = myPets.next();
        }
   	    
        Log.d(DEBUG_TAG, "Koniec dokumentu");
    	
    	
    }
    
	// Konwersja danych ze strumienia do postaci łańcucha znaków, tak by można go było
	// wyświetlić przy użyciu narzędzia LogCat
    public String inputStreamToString(InputStream is) throws IOException
    {
    	StringBuffer sBuffer = new StringBuffer();
    	DataInputStream dataIO = new DataInputStream(is);
    	String strLine = null;
    	
    	while((strLine=dataIO.readLine()) != null){
    			sBuffer.append(strLine+"\n");
    	}

    	dataIO.close();
    	is.close();

    	return sBuffer.toString();
    	
    }

    
}